<?php
session_start();
if (!isset($_SESSION['client_id'])) {
    header("Location: connexion.php");
    exit;
}
include("header.php");               

$link = mysqli_connect("localhost", "mathieuprosper_admin", "RE15om!+2615", "mathieuprosper_SAE203");

if (!$link) {
    die("Erreur DB: " . mysqli_connect_error());
}

$client_id = $_SESSION['client_id'];

// Rendre un algo si demandé
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reservation_id'])) {
    $reservation_id = intval($_POST['reservation_id']);

    // Met à jour la date de fin à maintenant
    $now = date('Y-m-d H:i:s');

    $update = "UPDATE reservations SET date_fin = '$now' 
               WHERE id = $reservation_id AND client_id = $client_id AND date_fin IS NULL";

    mysqli_query($link, $update);
}

// Affiche les réservations en cours
$query = "SELECT r.id, r.date_debut, r.prix_heure, a.nom 
          FROM reservations r
          JOIN algorithmes a ON r.algorithme_id = a.id
          WHERE r.client_id = $client_id AND r.date_fin IS NULL";

$result = mysqli_query($link, $query);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Mes Réservations</title>
     <link rel="stylesheet" href="Style_Reservation.css">
    <link rel="stylesheet" href="Style_Header.css">
</head>
<body>
    <h1>Mes Réservations en cours</h1>

    <?php if (mysqli_num_rows($result) === 0): ?>
        <p>Vous n'avez aucune réservation en cours.</p>
    <?php else: ?>
        <table border="1" cellpadding="10">
            <tr>
                <th>Algorithme</th>
                <th>Date de début</th>
                <th>Prix par heure</th>
                <th>Action</th>
            </tr>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                <tr>
                    <td><?= htmlspecialchars($row['nom']) ?></td>
                    <td><?= $row['date_debut'] ?></td>
                    <td><?= number_format($row['prix_heure'], 2) ?> €</td>
                    <td>
                        <form method="POST">
                            <input type="hidden" name="reservation_id" value="<?= $row['id'] ?>">
                            <button type="submit">Rendre</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
        </table>
    <?php endif; ?>

    <br><a href="index.php">← Retour à l'accueil</a>
</body>
</html>
