<?php
// index.php
require_once 'includes/db.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }

if (!isset($_SESSION['user_id'])) { 
    header('Location: login.php'); 
    exit(); 
}

// Récupération des infos joueur
$myId = $_SESSION['user_id'];
$qUser = mysqli_query($link, "
    SELECT u.login_user, p.victoires 
    FROM users u 
    JOIN user_profiles p ON u.id_user = p.user_id 
    WHERE u.id_user = $myId
");
$userData = mysqli_fetch_assoc($qUser);
$username = htmlspecialchars($userData['login_user']);
$victoires = (int)$userData['victoires'];

// Charger TOUS les vaisseaux pour le JS
$q_ships = mysqli_query($link, "SELECT * FROM vaisseaux");
$ships_data = [];
while($row = mysqli_fetch_assoc($q_ships)) {
    $row['victoires_necessaire'] = (int)$row['victoires_necessaire'];
    $ships_data[] = $row;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>QG Tactique - Flotte</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Rajdhani:wght@300;500;600;700&display=swap" rel="stylesheet">
    <style>
    /* --- CSS IDENTIQUE A VOTRE VERSION --- */
    :root { --neon-blue: #00f3ff; --neon-green: #0aff0a; --neon-red: #ff003c; --neon-gold: #ffd700; --glass-bg: rgba(16, 20, 30, 0.9); --bg-deep: #05070a; }
    body { background-color: var(--bg-deep); background-image: radial-gradient(white, rgba(255,255,255,.2) 2px, transparent 3px), radial-gradient(white, rgba(255,255,255,.15) 1px, transparent 2px); background-size: 550px 550px, 350px 350px; color: #e2e8f0; font-family: 'Rajdhani', sans-serif; margin: 0; padding-bottom: 100px; display: flex; flex-direction: column; height: 100vh; overflow-x: hidden; }
    h2, h3 { font-family: 'Orbitron', sans-serif; color: var(--neon-blue); text-transform: uppercase; letter-spacing: 3px; text-shadow: 0 0 10px rgba(0, 243, 255, 0.5); }
    b { color: var(--neon-blue); }
    .main-container { display: flex; flex-wrap: wrap; gap: 30px; max-width: 1400px; width: 95%; margin: 40px auto; }
    .fleet-section { flex: 3; min-width: 600px; }
    .radar-section { flex: 1; min-width: 300px; }
    .section-header { display: flex; justify-content: space-between; align-items: end; margin-bottom: 25px; border-bottom: 1px solid rgba(0, 243, 255, 0.3); padding-bottom: 15px; position: relative; }
    .victory-badge { background: rgba(255, 215, 0, 0.1); color: var(--neon-gold); border: 1px solid var(--neon-gold); padding: 4px 12px; border-radius: 2px; font-weight: 700; font-family: 'Orbitron', sans-serif; margin-left: 15px; }
    .fleet-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 20px; }
    .fleet-slot { background: linear-gradient(135deg, rgba(20,30,50,0.6) 0%, rgba(10,15,25,0.9) 100%); border: 1px solid rgba(66, 153, 225, 0.3); border-left: 4px solid #2d3748; padding: 20px; display: flex; flex-direction: column; justify-content: space-between; height: 140px; clip-path: polygon(0 0, 100% 0, 100% calc(100% - 15px), calc(100% - 15px) 100%, 0 100%); transition: 0.3s; }
    .fleet-slot:hover { transform: translateY(-5px); box-shadow: 0 5px 20px rgba(0,0,0,0.5); }
    .slot-filled { border-color: var(--neon-blue); border-left-color: var(--neon-blue); box-shadow: 0 0 15px rgba(0, 243, 255, 0.1); }
    .slot-empty { border: 1px dashed rgba(255,255,255,0.2); justify-content: center; align-items: center; cursor: pointer; color: #718096; background: rgba(0,0,0,0.3); }
    .slot-empty:hover { border-color: var(--neon-gold); color: var(--neon-gold); background: rgba(255, 215, 0, 0.05); }
    .ship-name { font-size: 1.4em; font-family: 'Orbitron', sans-serif; color: white; text-transform: uppercase; }
    .ship-type { color: var(--neon-blue); font-size: 0.9em; letter-spacing: 1px; display:block; margin-bottom:10px; }
    .btn-remove { background: transparent; color: var(--neon-red); border: 1px solid var(--neon-red); padding: 5px 10px; cursor: pointer; font-family: 'Rajdhani', sans-serif; font-weight: bold; font-size: 0.8em; }
    .btn-remove:hover { background: var(--neon-red); color: black; }
    .btn-random { background: rgba(128, 90, 213, 0.2); color: #d6bcfa; border: 1px solid #9f7aea; padding: 8px 25px; clip-path: polygon(10px 0, 100% 0, 100% 100%, 0 100%, 0 10px); cursor: pointer; font-family: 'Orbitron', sans-serif; }
    .btn-random:hover { background: #9f7aea; color: black; }
    .radar-panel { background: var(--glass-bg); border: 1px solid rgba(0, 243, 255, 0.2); padding: 20px; position: relative; overflow: hidden; }
    .radar-panel::before { content: ''; position: absolute; top: 0; left: 0; width: 100%; height: 2px; background: rgba(0, 243, 255, 0.5); box-shadow: 0 0 10px var(--neon-blue); animation: scan 3s infinite linear; pointer-events: none; }
    @keyframes scan { 0% { top: 0%; opacity:0; } 10% { opacity:1; } 90% { opacity:1; } 100% { top: 100%; opacity:0; } }
    .player-item { padding: 12px; border-bottom: 1px solid rgba(255,255,255,0.05); color: #e2e8f0; display: flex; justify-content: space-between; align-items: center; }
    .status-dot { height: 8px; width: 8px; background-color: var(--neon-green); border-radius: 50%; box-shadow: 0 0 8px var(--neon-green); animation: pulse-green 2s infinite; }
    @keyframes pulse-green { 0% { opacity: 0.5; } 50% { opacity: 1; box-shadow: 0 0 15px var(--neon-green); } 100% { opacity: 0.5; } }
    #action-bar { position: fixed; bottom: 0; left: 0; width: 100%; background: rgba(5, 7, 10, 0.95); border-top: 1px solid var(--neon-blue); padding: 20px; text-align: center; z-index: 500; display: flex; justify-content: center; align-items: center; gap: 30px; backdrop-filter: blur(10px); }
    #mainActionBtn { padding: 15px 50px; font-size: 1.2em; font-family: 'Orbitron', sans-serif; letter-spacing: 2px; border: none; cursor: pointer; clip-path: polygon(20px 0, 100% 0, 100% calc(100% - 20px), calc(100% - 20px) 100%, 0 100%, 0 20px); transition: 0.3s; }
    .btn-disabled { background: #2d3748; color: #718096; cursor: not-allowed; border: 1px solid #4a5568; }
    .btn-play { background: transparent; color: var(--neon-green); border: 2px solid var(--neon-green); }
    .btn-play:hover { background: var(--neon-green); color: black; box-shadow: 0 0 30px var(--neon-green); }
    .btn-cancel { background: transparent; color: var(--neon-red); border: 2px solid var(--neon-red); animation: pulse-red 1s infinite; }
    /* Modal styles */
    .modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.85); backdrop-filter: blur(8px); align-items: center; justify-content: center; }
    .modal-content { background-color: rgba(15, 20, 30, 0.98); color: white; border: 1px solid var(--neon-blue); width: 70%; max-width: 900px; height: 80vh; display: flex; flex-direction: column; padding: 30px; position: relative; clip-path: polygon(0 0, 100% 0, 100% calc(100% - 30px), calc(100% - 30px) 100%, 0 100%); }
    .close-btn { position: absolute; top: 20px; right: 25px; width: 35px; height: 35px; line-height: 33px; text-align: center; font-size: 24px; color: var(--neon-red); border: 1px solid var(--neon-red); cursor: pointer; transition: 0.2s; background: rgba(20,0,0,0.5); }
    .close-btn:hover { background: var(--neon-red); color: white; transform: rotate(90deg); }
    .table-container { overflow-y: auto; flex: 1; min-height: 0; background: rgba(0, 0, 0, 0.3); border: 1px solid rgba(255, 255, 255, 0.1); margin-top: 20px; }
    .table-container::-webkit-scrollbar { width: 8px; }
    .table-container::-webkit-scrollbar-thumb { background: var(--neon-blue); border-radius: 4px; }
    table { width: 100%; border-collapse: separate; border-spacing: 0 5px; }
    th { text-align: left; padding: 15px; background: rgba(0, 243, 255, 0.15); color: var(--neon-blue); position: sticky; top: 0; backdrop-filter: blur(5px); cursor: pointer; }
    td { padding: 15px; background: rgba(255,255,255,0.03); border-bottom: 1px solid rgba(255,255,255,0.05); }
    .btn-select { background: transparent; color: var(--neon-blue); border: 1px solid var(--neon-blue); padding: 6px 15px; cursor: pointer; font-family: 'Orbitron', sans-serif; font-size: 0.8em; transition: 0.2s; }
    .btn-select:hover { background: var(--neon-blue); color: black; }
    .btn-locked { border-color: #4a5568; color: #718096; cursor: not-allowed; }
    .btn-locked:hover { background: transparent; color: #718096; }
    #searchShip { background: rgba(0,0,0,0.5); border: 1px solid #4a5568; color: white; padding: 15px; width: 100%; font-family: 'Rajdhani', sans-serif; font-size: 1.1em; outline: none; box-sizing: border-box; }
    #searchShip:focus { border-color: var(--neon-blue); }
    </style>
</head>
<body>

    <script>
        const DB_SHIPS = <?php echo json_encode($ships_data); ?>;
        const USER_VICTORIES = <?php echo $victoires; ?>;
    </script>

    <div class="main-container">
        <div class="fleet-section">
            <div class="section-header">
                <div>
                    <h2>QG de la Flotte</h2>
                    <p style="color:#a0aec0; margin:0;">
                        Commandant : <b><?php echo $username; ?></b>
                        <span class="victory-badge">🏆 Victoires: <?php echo $victoires; ?></span>
                    </p>
                </div>
                <button class="btn-random" onclick="fillFleetRandomly()">
                    🎲 SELECTION AUTO
                </button>
            </div>
            
            <div id="fleet-container" class="fleet-grid"></div>
        </div>

        <div class="radar-section">
            <div class="radar-panel">
                <div class="radar-title" style="color:var(--neon-gold); font-family:'Orbitron'; font-weight:bold; margin-bottom:15px; display:flex; justify-content:space-between;">
                    <span>📡 RADAR - JOUEURS PRÊTS</span>
                    <span id="player-count" style="color:white">0</span>
                </div>
                <div id="radar-content">
                    <ul id="ready-players-list" style="list-style:none; padding:0; margin:0;"></ul>
                    <p id="no-players-msg" style="color:#a0aec0; text-align:center; padding:20px;">Balayage du secteur...</p>
                </div>
            </div>
        </div>
    </div>

    <div id="action-bar">
        <span id="status-text" style="font-weight: bold; color: #a0aec0;">Flotte vide</span>
        <button id="mainActionBtn" class="btn-disabled" disabled>JOUER</button>
    </div>

    <div id="shipModal" class="modal">
        <div class="modal-content">
            <div style="border-bottom: 1px solid rgba(0, 243, 255, 0.3); padding-bottom: 15px; margin-bottom: 20px;">
                <h3 style="margin:0">Hangar : Sélectionner un vaisseau</h3>
                <span class="close-btn" onclick="closeModals()">&times;</span>
            </div>
            <input type="text" id="searchShip" placeholder="Rechercher (Nom ou Type)...">
            
            <div class="table-container">
                <table id="shipTable">
                    <thead>
                        <tr>
                            <th onclick="sortTable('shipTable', 0)">Nom &#8597;</th>
                            <th onclick="sortTable('shipTable', 1)">Type &#8597;</th>
                            <th onclick="sortTable('shipTable', 2)">PV &#8597;</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="shipTableBody"></tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        let myFleet = []; 
        let lobbyState = 0;

        $(document).ready(function() {
            renderFleet();
            setInterval(checkLobbyStatus, 2000);
            setInterval(updateRadar, 3000);
            checkLobbyStatus();
            updateRadar();
        });

        // --- GESTION AJAX CENTRALISÉE ---

        function updateRadar() {
            $.ajax({
                url: 'api/action_game.php',
                type: 'POST',
                data: { action: 'get_radar' },
                dataType: 'json',
                success: function(res) {
                    if(res.success && res.players) {
                        const list = $('#ready-players-list');
                        const countSpan = $('#player-count');
                        const msg = $('#no-players-msg');
                        list.empty();
                        countSpan.text(res.players.length);

                        if (res.players.length === 0) msg.show().text("Aucun signal détecté...");
                        else {
                            msg.hide();
                            res.players.forEach(p => {
                                let nameStyle = p.is_me ? 'color: #63b3ed; font-weight: bold;' : 'color: #e2e8f0;';
                                let suffix = p.is_me ? ' (Vous)' : '';
                                list.append(`<li class="player-item"><span style="${nameStyle}">${p.login_user}${suffix}</span><span class="status-dot"></span></li>`);
                            });
                        }
                    }
                }
            });
        }

        function checkLobbyStatus() {
            $.ajax({
                url: 'api/action_game.php',
                type: 'POST',
                data: { action: 'check_lobby_status' },
                dataType: 'json',
                success: function(data) {
                    if (data.opponent_id) window.location.href = 'univers.php';
                    lobbyState = data.am_i_ready; 
                    updateActionBar();
                }
            });
        }

        // --- GESTION BOUTON PRINCIPAL ---
        $('#mainActionBtn').click(function() {
            let currentAction = (lobbyState === 1) ? 'cancel_lobby' : 'join_lobby';
            let requestData = { action: currentAction };

            if (currentAction === 'join_lobby') {
                // On formate la flotte en un tableau d'objets simple pour PHP
                requestData.fleet = myFleet.map(s => ({ ship_id: s.shipId }));
            }

            $.ajax({
                url: 'api/action_game.php',
                type: 'POST',
                data: requestData,
                dataType: 'json',
                success: function(resp) {
                    if(!resp.success && resp.msg) {
                        alert("Erreur: " + resp.msg);
                    }
                    checkLobbyStatus();
                },
                error: function() {
                    alert("Erreur de connexion au QG.");
                }
            });
        });

        // --- UI & LOGIQUE FLOTTE ---

        function fillFleetRandomly() {
            myFleet = [];
            let unlockedShips = DB_SHIPS.filter(s => USER_VICTORIES >= s.victoires_necessaire);
            if (unlockedShips.length < 5) {
                alert("Pas assez de vaisseaux débloqués (min 5).");
                return;
            }
            let shuffled = [...unlockedShips].sort(() => 0.5 - Math.random());
            shuffled.slice(0, 5).forEach(s => {
                myFleet.push({ shipId: s.id, shipName: s.nom, type: s.type, hp: s.points_vie });
            });
            renderFleet();
        }

        function renderFleet() {
            const container = $('#fleet-container');
            container.empty();
            myFleet.forEach((slot, index) => {
                container.append(`
                    <div class="fleet-slot slot-filled">
                        <div>
                            <span class="ship-name">${slot.shipName}</span>
                            <span class="ship-type">${slot.type.toUpperCase()}</span>
                            <span style="font-size:0.9em; color:#a0aec0;">PV: ${slot.hp}</span>
                        </div>
                        <button class="btn-remove" onclick="removeShip(${index})">RETIRER</button>
                    </div>
                `);
            });
            if (myFleet.length < 5) {
                container.append(`
                    <div class="fleet-slot slot-empty" onclick="openShipModal()">
                        <div style="font-size: 2em; margin-bottom: 10px;">+</div>
                        <div>AJOUTER</div>
                        <small style="color:#718096">${myFleet.length + 1} / 5</small>
                    </div>
                `);
            }
            updateActionBar();
        }

        function updateActionBar() {
            let btn = $('#mainActionBtn');
            let txt = $('#status-text');
            btn.removeClass('btn-play btn-cancel btn-disabled').prop('disabled', false);

            if (lobbyState === 1) {
                btn.text("ANNULER RECHERCHE").addClass('btn-cancel');
                txt.text("RECHERCHE D'ADVERSAIRE...");
                $('.btn-remove, .slot-empty').css('pointer-events', 'none').css('opacity', '0.5');
                return;
            }
            $('.btn-remove, .slot-empty').css('pointer-events', 'auto').css('opacity', '1');
            
            if (myFleet.length === 5) {
                btn.text("LANCER LE COMBAT").addClass('btn-play');
                txt.text("FLOTTE OPÉRATIONNELLE");
            } else {
                btn.text(`EN ATTENTE (${myFleet.length}/5)`).addClass('btn-disabled').prop('disabled', true);
                txt.text(`Sélectionnez 5 vaisseaux.`);
            }
        }

        function openShipModal() { $('#shipModal').fadeIn(200).css('display', 'flex'); renderShipTable(); }
        window.closeModals = function() { $('.modal').fadeOut(200); };

        function renderShipTable() {
            const tbody = $('#shipTableBody');
            tbody.empty();
            let filter = $('#searchShip').val().toLowerCase();
            let takenIds = myFleet.map(s => s.shipId);

            DB_SHIPS.forEach(ship => {
                if (filter && !ship.nom.toLowerCase().includes(filter) && !ship.type.toLowerCase().includes(filter)) return;
                if (takenIds.includes(ship.id)) return;

                let isLocked = USER_VICTORIES < ship.victoires_necessaire;
                let btn = isLocked 
                    ? `<button class="btn-select btn-locked" disabled>🔒 Req: ${ship.victoires_necessaire} 🏆</button>`
                    : `<button class="btn-select" onclick="addShipToFleet(${ship.id})">CHOISIR</button>`;

                tbody.append(`
                    <tr>
                        <td style="font-weight:bold; color:white;">${ship.nom}</td>
                        <td style="color:#90cdf4">${ship.type}</td>
                        <td>${ship.points_vie}</td>
                        <td>${btn}</td>
                    </tr>
                `);
            });
        }

        window.addShipToFleet = function(id) {
            let s = DB_SHIPS.find(x => x.id == id);
            if (USER_VICTORIES < s.victoires_necessaire) return;
            myFleet.push({ shipId: s.id, shipName: s.nom, type: s.type, hp: s.points_vie });
            closeModals();
            renderFleet();
        };

        window.removeShip = function(index) { myFleet.splice(index, 1); renderFleet(); };
        $('#searchShip').on('keyup', renderShipTable);

        window.sortTable = function(tableId, n) {
            var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
            table = document.getElementById(tableId);
            switching = true; dir = "asc";
            while (switching) {
                switching = false; rows = table.rows;
                for (i = 1; i < (rows.length - 1); i++) {
                    shouldSwitch = false;
                    x = rows[i].getElementsByTagName("TD")[n];
                    y = rows[i + 1].getElementsByTagName("TD")[n];
                    let xVal = isNaN(x.innerHTML) ? x.innerHTML.toLowerCase() : parseFloat(x.innerHTML);
                    let yVal = isNaN(y.innerHTML) ? y.innerHTML.toLowerCase() : parseFloat(y.innerHTML);
                    if (dir == "asc") { if (xVal > yVal) { shouldSwitch = true; break; } } 
                    else if (dir == "desc") { if (xVal < yVal) { shouldSwitch = true; break; } }
                }
                if (shouldSwitch) {
                    rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
                    switching = true; switchcount++;
                } else {
                    if (switchcount == 0 && dir == "asc") { dir = "desc"; switching = true; }
                }
            }
        };
    </script>
</body>
</html>