<?php
// login.php
require_once 'includes/db.php'; // Connexion centralisée

if ($_POST) {
    $login = mysqli_real_escape_string($link, $_POST['login']);
    $password = $_POST['password'];
    
    // Requête sécurisée
    $stmt = mysqli_prepare($link, "SELECT * FROM users WHERE login_user = ?");
    mysqli_stmt_bind_param($stmt, 's', $login);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if ($row = mysqli_fetch_assoc($result)) {
        // Utilisateur existant
        if (password_verify($password, $row['pwd_user'])) {
            $_SESSION['user_id'] = $row['id_user'];
            $_SESSION['username'] = $row['login_user'];
            header('Location: index.php');
            exit();
        } else {
            $message = "Mot de passe incorrect";
        }
    } else {
        // Création de compte (Register)
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmtIns = mysqli_prepare($link, "INSERT INTO users (login_user, pwd_user) VALUES (?, ?)");
        mysqli_stmt_bind_param($stmtIns, 'ss', $login, $hashed_password);
        
        if (mysqli_stmt_execute($stmtIns)) {
            $user_id = mysqli_insert_id($link);
            $_SESSION['user_id'] = $user_id;
            $_SESSION['username'] = $login;
            
            // Création profil joueur
            mysqli_query($link, "INSERT INTO user_profiles (user_id, ready) VALUES ($user_id, 0)");
            
            header('Location: index.php');
            exit();
        } else {
            $message = "Erreur création compte";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Connexion - Fondation</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Rajdhani:wght@300;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            background-color: #05070a;
            background-image: 
                radial-gradient(white, rgba(255,255,255,.2) 2px, transparent 3px),
                radial-gradient(white, rgba(255,255,255,.15) 1px, transparent 2px),
                radial-gradient(white, rgba(255,255,255,.1) 2px, transparent 3px);
            background-size: 550px 550px, 350px 350px, 250px 250px;
            background-position: 0 0, 40px 60px, 130px 270px;
            color: #00f3ff;
            font-family: 'Rajdhani', sans-serif;
            height: 100vh;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .container {
            background: rgba(10, 15, 30, 0.85);
            backdrop-filter: blur(10px);
            padding: 40px;
            border: 1px solid #00f3ff;
            box-shadow: 0 0 20px rgba(0, 243, 255, 0.2), inset 0 0 50px rgba(0, 0, 0, 0.5);
            width: 350px;
            text-align: center;
            position: relative;
            clip-path: polygon(
                20px 0, 100% 0, 
                100% calc(100% - 20px), calc(100% - 20px) 100%, 
                0 100%, 0 20px
            );
        }

        /* Effet scanline */
        .container::after {
            content: " ";
            display: block;
            position: absolute;
            top: 0; left: 0; bottom: 0; right: 0;
            background: linear-gradient(rgba(18, 16, 16, 0) 50%, rgba(0, 0, 0, 0.25) 50%), linear-gradient(90deg, rgba(255, 0, 0, 0.06), rgba(0, 255, 0, 0.02), rgba(0, 0, 255, 0.06));
            z-index: 2;
            background-size: 100% 2px, 3px 100%;
            pointer-events: none;
        }

        h1 {
            font-family: 'Orbitron', sans-serif;
            letter-spacing: 2px;
            margin-bottom: 30px;
            text-transform: uppercase;
            text-shadow: 0 0 10px #00f3ff;
        }

        input {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            background: rgba(0, 0, 0, 0.5);
            border: 1px solid #2d3748;
            border-left: 3px solid #2d3748;
            color: white;
            font-family: 'Rajdhani', sans-serif;
            font-size: 1.1em;
            box-sizing: border-box;
            outline: none;
            transition: 0.3s;
        }

        input:focus {
            border-color: #00f3ff;
            border-left: 3px solid #00f3ff;
            box-shadow: 0 0 10px rgba(0, 243, 255, 0.3);
        }

        button {
            width: 100%;
            padding: 12px;
            margin-top: 20px;
            background: transparent;
            color: #00f3ff;
            border: 1px solid #00f3ff;
            font-family: 'Orbitron', sans-serif;
            font-weight: bold;
            font-size: 1.1em;
            cursor: pointer;
            transition: 0.3s;
            text-transform: uppercase;
            position: relative;
            overflow: hidden;
        }

        button:hover {
            background: #00f3ff;
            color: #000;
            box-shadow: 0 0 20px rgba(0, 243, 255, 0.6);
        }

        .error-msg {
            color: #ff003c;
            margin-top: 15px;
            font-weight: bold;
            text-shadow: 0 0 5px rgba(255, 0, 60, 0.5);
            animation: flash 1s infinite;
        }

        @keyframes flash { 0% { opacity: 1; } 50% { opacity: 0.5; } 100% { opacity: 1; } }
    </style>
</head>
<body>
    <div class="container"> 
        <h1>Connexion Flotte</h1>
        <form method="POST">
            <input type="text" name="login" placeholder="Identifiant" required>
            <input type="password" name="password" placeholder="Mot de passe" required>
            <button type="submit">Entrer</button>
        </form>
        <?php if (isset($message)) echo "<p style='color:red;'>$message</p>"; ?>
    </div>
</body>
</html>