<?php
// univers.php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once 'includes/db.php'; 

if (!isset($_SESSION['user_id'])) { 
    header('Location: index.php'); 
    exit(); 
}

$user_id = $_SESSION['user_id'];
// Vérification rapide que l'utilisateur est bien en match
$check_query = mysqli_query($link, "SELECT opponent_id FROM user_profiles WHERE user_id = $user_id");
$user_profile = mysqli_fetch_assoc($check_query);

if (!$user_profile || empty($user_profile['opponent_id'])) {
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Univers - Combat 1v1</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Rajdhani:wght@300;500;600;700&display=swap" rel="stylesheet">

    <style>
        /* CSS IDENTIQUE (conservé pour le style) */
        :root { --grid-line: rgba(0, 243, 255, 0.15); --neon-blue: #00f3ff; --neon-red: #ff003c; --neon-green: #0aff0a; --bg-deep: #05070a; --neon-gold: #ffd700; }
        body { background-color: var(--bg-deep); background-image: radial-gradient(circle at center, #1b2735 0%, #090a0f 100%); color: white; font-family: 'Rajdhani', sans-serif; margin: 0; display: flex; flex-direction: column; align-items: center; justify-content: center; height: 100vh; user-select: none; overflow: hidden; }
        #hud-container { display: flex; justify-content: space-between; align-items: center; width: 520px; margin-bottom: 15px; background: rgba(10, 15, 25, 0.9); border: 1px solid var(--neon-blue); box-shadow: 0 0 20px rgba(0, 243, 255, 0.1); padding: 15px 30px; clip-path: polygon(15px 0, 100% 0, 100% 100%, 0 100%, 0 15px); box-sizing: border-box; }
        .hud-turn { font-family: 'Orbitron', sans-serif; font-size: 1.4em; letter-spacing: 2px; }
        .turn-player { color: var(--neon-blue); text-shadow: 0 0 10px var(--neon-blue); } 
        .turn-enemy { color: var(--neon-red); text-shadow: 0 0 10px var(--neon-red); }
        .hud-timer { font-family: 'Orbitron', monospace; font-size: 1.5em; color: white; }
        .timer-warning { color: var(--neon-red); animation: pulse 0.5s infinite; }
        #game-grid { display: grid; grid-template-columns: repeat(10, 1fr); width: 500px; height: 500px; border: 2px solid var(--neon-blue); background: rgba(0, 10, 20, 0.8); box-shadow: 0 0 50px rgba(0, 243, 255, 0.1), inset 0 0 50px rgba(0,0,0,0.8); position: relative; transform: perspective(1000px) rotateX(10deg); margin-bottom: 20px; }
        .cell { border: 1px solid var(--grid-line); display: flex; align-items: center; justify-content: center; position: relative; z-index: 10; }
        .entity { width: 70%; height: 70%; position: relative; transition: 0.3s; z-index: 15; display: flex; justify-content: center; align-items: center; }
        .entity-shape { width: 100%; height: 100%; position: absolute; top: 0; left: 0; clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%); box-shadow: 0 0 15px currentColor; transition: transform 0.3s, filter 0.3s; z-index: 1; }
        .hp-bar { position: absolute; top: -12px; left: 50%; transform: translateX(-50%); width: 120%; height: 4px; background: #222; border: 1px solid #000; z-index: 20; pointer-events: none; }
        .hp-fill { height: 100%; width: 100%; transition: width 0.3s; }
        .type-ship { background-color: var(--neon-blue); color: var(--neon-blue); }
        .type-enemy { background-color: var(--neon-red); color: var(--neon-red); } 
        .type-soigneur { background-color: var(--neon-green); color: var(--neon-green); border: 2px solid white; }
        .type-drone { width: 50%; height: 50%; border-radius: 50%; clip-path: none !important; }
        .drone-kamikaze { background-color: #dd6b20; color: #dd6b20; box-shadow: 0 0 10px #dd6b20; }
        .drone-scout { background-color: #d53f8c; color: #d53f8c; box-shadow: 0 0 10px #d53f8c; }
        .is-hidden { opacity: 0; pointer-events: none; } 
        .entity:hover .entity-shape { transform: scale(1.2); filter: brightness(1.5); }
        .entity:hover { z-index: 100; }
        .entity-shape.active { border: 2px solid white; box-shadow: 0 0 25px white; }
        .cell.valid-move { background-color: rgba(0, 243, 255, 0.15); cursor: pointer; box-shadow: inset 0 0 10px var(--neon-blue); }
        .cell.valid-drone { background-color: rgba(214, 188, 250, 0.2); cursor: crosshair; }
        .entity-shape.valid-target { animation: pulse-target 1s infinite; cursor: crosshair !important; border: 2px solid white; }
        @keyframes pulse-target { 0% { box-shadow: 0 0 0 rgba(255, 0, 60, 0.4); } 50% { box-shadow: 0 0 25px rgba(255, 0, 60, 1); } }
        .entity-shape.valid-ally { animation: pulse-ally 1s infinite; cursor: crosshair !important; border: 2px solid white; }
        @keyframes pulse-ally { 0% { box-shadow: 0 0 0 rgba(10, 255, 10, 0.4); } 50% { box-shadow: 0 0 25px rgba(10, 255, 10, 1); } }
        .laser-beam { position: absolute; height: 3px; background: var(--neon-red); box-shadow: 0 0 10px var(--neon-red), 0 0 20px var(--neon-red); z-index: 100; pointer-events: none; opacity: 1; transition: opacity 0.5s ease-out; transform-origin: 0 50%; }
        .heal-beam { position: absolute; height: 4px; background: var(--neon-green); box-shadow: 0 0 15px var(--neon-green); z-index: 100; pointer-events: none; opacity: 1; transition: opacity 0.5s ease-out; transform-origin: 0 50%; }
        .explosion-effect { position: absolute; width: 100px; height: 100px; background: radial-gradient(circle, #fff 0%, var(--neon-red) 40%, transparent 70%); border-radius: 50%; pointer-events: none; z-index: 200; transform: translate(-30%, -30%); animation: boom-anim 0.6s ease-out forwards; mix-blend-mode: screen; }
        @keyframes boom-anim { 0% { transform: translate(-30%, -30%) scale(0.1); opacity: 1; } 100% { transform: translate(-30%, -30%) scale(2); opacity: 0; } }
        .toolbar { margin-bottom: 20px; display: flex; gap: 15px; }
        .btn-tool { border: 1px solid white; padding: 10px 20px; cursor: pointer; font-weight: bold; color: white; transition: 0.2s; font-family: 'Orbitron'; letter-spacing: 1px; text-transform: uppercase; background: transparent; }
        .btn-end-turn { border-color: var(--neon-gold); color: var(--neon-gold); } 
        .btn-end-turn:hover { background: var(--neon-gold); color: black; box-shadow: 0 0 20px var(--neon-gold); }
        .btn-surrender { border-color: var(--neon-red); color: var(--neon-red); }
        .btn-surrender:hover { background: var(--neon-red); color: white; box-shadow: 0 0 20px var(--neon-red); }
        #action-panel { display: none; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: rgba(10, 15, 25, 0.95); border: 1px solid var(--neon-blue); box-shadow: 0 0 40px rgba(0, 243, 255, 0.2); z-index: 200; width: 320px; backdrop-filter: blur(10px); clip-path: polygon(20px 0, 100% 0, 100% calc(100% - 20px), calc(100% - 20px) 100%, 0 100%, 0 20px); }
        .panel-header { background: rgba(0, 243, 255, 0.1); padding: 15px; font-weight: bold; color: var(--neon-blue); text-align: center; font-family: 'Orbitron'; border-bottom: 1px solid rgba(0, 243, 255, 0.3); }
        .panel-content { padding: 20px; }
        .stat-row { display: flex; justify-content: space-between; margin-bottom: 10px; border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 5px; }
        .btn { display: block; width: 100%; padding: 12px; margin-top: 8px; border: 1px solid transparent; cursor: pointer; font-weight: bold; color: white; font-family: 'Rajdhani'; font-size: 1.1em; text-transform: uppercase; transition: 0.2s; background: rgba(255,255,255,0.05); }
        .btn:hover { border-color: white; transform: translateX(5px); }
        .btn-act { color: var(--neon-blue); border-color: var(--neon-blue); } .btn-act:hover { background: var(--neon-blue); color: black; }
        .btn-atk { color: var(--neon-red); border-color: var(--neon-red); } .btn-atk:hover { background: var(--neon-red); color: white; }
        .btn-heal { color: var(--neon-green); border-color: var(--neon-green); }
        #overlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); backdrop-filter: blur(3px); z-index: 150; }
        #status-text { color: #a0aec0; margin-top: 10px; height: 20px; text-align: center; font-family: 'Orbitron'; }
        #btn-cancel-action { display: none; background: transparent; color: var(--neon-red); border: 1px solid var(--neon-red); padding: 8px 25px; margin-top:15px; cursor: pointer; font-family: 'Orbitron'; }
        #btn-cancel-action:hover { background: var(--neon-red); color: white; box-shadow: 0 0 15px var(--neon-red); }
        #end-game-modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.9); z-index: 300; flex-direction: column; align-items: center; justify-content: center; backdrop-filter: blur(10px); }
        .end-content { background: rgba(10,15,20,1); border: 2px solid white; padding: 40px; text-align: center; max-width: 400px; box-shadow: 0 0 100px rgba(0,243,255,0.2); }
        .end-title { font-size: 3em; font-weight: bold; margin-bottom: 10px; font-family: 'Orbitron'; text-transform: uppercase; }
        .win-title { color: var(--neon-green); text-shadow: 0 0 20px var(--neon-green); } 
        .lose-title { color: var(--neon-red); text-shadow: 0 0 20px var(--neon-red); }
        .btn-quit { background: transparent; color: white; border: 1px solid white; padding: 15px 30px; font-size: 1.2em; cursor: pointer; font-weight: bold; width: 100%; margin-top:20px; font-family: 'Orbitron'; transition: 0.3s; }
        .btn-quit:hover { background: white; color: black; box-shadow: 0 0 30px white; }
    </style>
</head>
<body>

    <div id="overlay"></div>

    <div id="end-game-modal">
        <div class="end-content">
            <div id="end-title" class="end-title">TITRE</div>
            <div id="end-msg" class="end-msg">Message de fin</div>
            <button class="btn-quit" onclick="quitGame()">RETOUR QG</button>
        </div>
    </div>
    
    <div id="action-panel">
        <div class="panel-header" id="panel-title">UNITÉ</div>
        <div class="panel-content">
            <div id="view-infos">
                <div class="stat-row"><span style="color:#a0aec0">Appartenance</span><span id="info-owner" style="font-weight:bold;">--</span></div>
                <div class="stat-row"><span style="color:#a0aec0">PV</span><span id="info-hp">--</span></div>
                <div class="stat-row"><span style="color:#a0aec0">Type</span><span id="info-type">--</span></div>
                <div class="stat-row"><span style="color:#a0aec0">Énergie</span><span id="info-energy">--</span></div>
                <div style="margin-top: 15px;">
                    <button id="btn-orders" class="btn btn-primary" style="background:#4299e1" onclick="showActionsView()">ORDRES</button>
                    <button class="btn btn-red" onclick="closePanel()">FERMER</button>
                </div>
            </div>
            <div id="view-actions" style="display:none;">
                <button class="btn btn-act" onclick="activateMoveMode()">DÉPLACER</button>
                <div id="controls-ship">
                    <button class="btn btn-atk" id="btn-attack" onclick="activateAttackMode()">TIRER (10 E)</button>
                    <hr style="border: 0; border-top: 1px solid #4a5568; margin: 10px 0;">
                    <button class="btn btn-kami" id="btn-deploy-kami" onclick="activateDroneMode('kamikaze')">DRONE KAMIKAZE (40 E)</button>
                    <button class="btn btn-scout" id="btn-deploy-scout" onclick="activateDroneMode('scout')">DRONE ÉCLAIREUR (20 E)</button>
                </div>
                <div id="controls-healer" style="display:none;">
                    <button class="btn btn-heal" onclick="activateHealMode()">➕ RÉPARER ALLIÉ (20 E)</button>
                </div>
                <div id="controls-drone-kami" style="display:none; margin-top:10px;">
                    <button class="btn btn-explode" onclick="commitExplosion()">💥 AUTO-DESTRUCTION (ZONE)</button>
                </div>
                <div style="margin-top: 10px; padding-top:10px; border-top:1px solid #4a5568;">
                    <button class="btn" style="background:#718096" onclick="showInfosView()">RETOUR</button>
                </div>
            </div>
        </div>
    </div>

    <div id="hud-container">
        <div class="hud-turn turn-player" id="turn-label">CHARGEMENT...</div>
        <div class="hud-timer" id="timer-display">60</div>
    </div>

    <div class="toolbar">
        <button class="btn-tool btn-end-turn" id="btn-end-turn" onclick="endTurn()">⏳ FINIR LE TOUR</button>
        <div style="width:1px; background:#4a5568; margin:0 10px;"></div>
        <button class="btn-tool btn-surrender" onclick="surrenderGame()">🏳️ ABANDONNER</button>
    </div>

    <div id="game-container">
        <div id="game-grid"></div>
    </div>
    
    <p id="status-text">Synchronisation...</p>
    <button id="btn-cancel-action" onclick="cancelCurrentOrder()">✖ ANNULER L'ORDRE</button>

    <script>
    // --- VARIABLES GLOBALES ---
    let ships = []; 
    let currentTurn = 'player';
    let previousTurn = null; 
    let selectedShipId = null;
    let mode = null; 
    let droneTypeToDeploy = null; 
    let gameOver = false;
    let visualTimer = 60;
    let timerIntervalId = null;
    let previousShipsState = {}; 

    $(document).ready(function() { 
        syncState();
        setInterval(syncState, 2000); 
        startVisualTimer(); 
    });

    // --- TIMER VISUEL ---
    function startVisualTimer() {
        if (timerIntervalId) clearInterval(timerIntervalId);
        timerIntervalId = setInterval(function() {
            if (visualTimer > 0) visualTimer--;
            else if (currentTurn === 'player' && !gameOver) {
                visualTimer = 60; 
                $('#status-text').text("Temps écoulé ! Fin du tour auto.");
                endTurn();
            }
            let sec = visualTimer < 10 ? "0" + visualTimer : visualTimer;
            $('#timer-display').text("00:" + sec).toggleClass('timer-warning', visualTimer <= 10);
        }, 1000);
    }

    // --- AJAX & SYNCHRONISATION ---

    function syncState() {
        if(mode !== null || gameOver) return;
        
        $.ajax({
            url: 'api/action_game.php',
            type: 'POST',
            data: { action: 'get_state' },
            dataType: 'json',
            success: function(res) {
                if (res.gameState && res.gameState.game_over === true) {
                    window.location.href = 'index.php';
                    return;
                }
                if(res.gameState) {
                    if (res.gameState.win === 'WIN') { showEndScreen("VICTOIRE", "L'ennemi a été éliminé.", true); return; }
                    if (res.gameState.win === 'LOSE') { showEndScreen("DÉFAITE", "Votre flotte a été anéantie.", false); return; }

                    ships = res.gameState.entities;
                    currentTurn = res.gameState.turn;
                    
                    if (currentTurn !== previousTurn) {
                        visualTimer = 60; 
                        previousTurn = currentTurn;
                        $('#status-text').text("Nouveau tour tactique.");
                    }
                    renderGame();
                    updateHud(res.msg);
                }
            }
        });
    }

    window.quitGame = function() {
        $.ajax({
            url: 'api/action_game.php',
            type: 'POST',
            data: { action: 'quit' },
            success: function() { window.location.href = 'index.php'; }
        });
    };

    function commitMove(x, y) {
        $.ajax({
            url: 'api/action_game.php',
            type: 'POST',
            data: { action: 'move', id: selectedShipId, x: x, y: y },
            dataType: 'json',
            success: function(res) {
                resetMode(res.msg); 
                setTimeout(syncState, 200);
            }
        });
    }

    function commitDrone(x, y) {
        $.ajax({
            url: 'api/action_game.php',
            type: 'POST',
            data: { action: 'spawn_drone', parentId: selectedShipId, type: droneTypeToDeploy, x: x, y: y },
            dataType: 'json',
            success: function(res) { resetMode(res.msg); syncState(); }
        });
    }

    function commitAttack(target) {
        let attacker = ships.find(s => parseInt(s.id) === parseInt(selectedShipId));
        if (!attacker) { resetMode("Erreur: Attaquant introuvable."); return; }
        $.ajax({
            url: 'api/action_game.php',
            type: 'POST',
            data: { action: 'attack', attackerId: selectedShipId, targetId: target.id },
            dataType: 'json',
            success: function(res) {
                if(res.success) fireLaserEffect(attacker, target);
                resetMode(res.msg); syncState();
            }
        });
    }

    function commitHeal(target) {
        let healer = ships.find(s => parseInt(s.id) === parseInt(selectedShipId));
        $.ajax({
            url: 'api/action_game.php',
            type: 'POST',
            data: { action: 'heal', healerId: selectedShipId, targetId: target.id },
            dataType: 'json',
            success: function(res) {
                if(res.success && healer) fireHealEffect(healer, target);
                resetMode(res.msg); syncState();
            }
        });
    }

    window.commitExplosion = function() {
        if(confirm("ALERTE: Auto-destruction irréversible. Confirmer ?")) {
            $.ajax({
                url: 'api/action_game.php',
                type: 'POST',
                data: { action: 'explode', droneId: selectedShipId },
                dataType: 'json',
                success: function(res) {
                    if(res.success) fireExplosionEffect(res.x, res.y);
                    closePanel(true); syncState();
                }
            });
        }
    };
    
    window.endTurn = function() {
        $('#status-text').text("Transmission fin de cycle...");
        $.ajax({
            url: 'api/action_game.php',
            type: 'POST',
            data: { action: 'end_turn' },
            dataType: 'json',
            success: function(res) { resetMode(res.msg); syncState(); }
        });
    };

    window.surrenderGame = function() {
        if (confirm("Abandonner le secteur ?")) {
            $.ajax({
                url: 'api/action_game.php',
                type: 'POST',
                data: { action: 'surrender' },
                dataType: 'json',
                success: function(res) { quitGame(); }
            });
        }
    };

    // --- MOTEUR RENDU & FX (Code identique mais nettoyé) ---

    function showEndScreen(title, msg, isWin) {
        gameOver = true;
        $('#end-game-modal').css('display', 'flex'); 
        $('#end-title').text(title).removeClass('win-title lose-title').addClass(isWin ? 'win-title' : 'lose-title');
        $('#end-msg').text(msg);
    }

    function renderGame() {
        const grid = $('#game-grid');
        grid.empty();
        let currentIds = ships.map(s => parseInt(s.id));

        for (let id in previousShipsState) {
            if (!currentIds.includes(parseInt(id))) {
                let d = previousShipsState[id];
                playDeathAnimation(d.x, d.y);
            }
        }

        for (let y = 0; y < 10; y++) {
            for (let x = 0; x < 10; x++) {
                let cell = $('<div class="cell"></div>').attr('data-x', x).attr('data-y', y);
                let entity = ships.find(s => parseInt(s.x) === x && parseInt(s.y) === y);

                if (!entity && currentTurn === 'player' && selectedShipId) {
                    let actor = ships.find(s => parseInt(s.id) === parseInt(selectedShipId));
                    if(actor) {
                        let dist = getDistance(actor.x, actor.y, x, y);
                        if (mode === 'move') {
                            let maxMove = (actor.subtype && actor.subtype.toLowerCase() === 'chasseur') ? 2 : 1;
                            if (dist <= maxMove) cell.addClass('valid-move').click(() => { playWarpOutEffect(actor.x, actor.y); commitMove(x, y); });
                        } else if (mode === 'drone' && dist === 1) {
                            cell.addClass('valid-drone').click(() => commitDrone(x, y));
                        }
                    }
                }

                if (entity) {
                    let visual = createEntityVisual(entity);
                    let shape = visual.find('.entity-shape');
                    let actor = selectedShipId ? ships.find(s => parseInt(s.id) === parseInt(selectedShipId)) : null;
                    let prevState = previousShipsState[entity.id];
                    let isNew = !prevState;
                    let hasMoved = prevState && (parseInt(prevState.x) !== parseInt(entity.x) || parseInt(prevState.y) !== parseInt(entity.y));

                    if (prevState && prevState.hp > entity.hp) shape.addClass('anim-hit');
                    if (entity.type === 'drone' && isNew) shape.addClass('anim-spawn');
                    else if (hasMoved || (isNew && Object.keys(previousShipsState).length > 0)) shape.addClass('anim-arrival');
                    else shape.addClass('anim-idle');

                    if (mode === 'attack' && actor && parseInt(entity.id) !== parseInt(selectedShipId) && currentTurn === 'player') {
                        let dist = getDistance(actor.x, actor.y, entity.x, entity.y);
                        if (dist <= 4 && entity.type === 'enemy' && !entity.hidden) {
                            shape.removeClass('anim-idle').addClass('valid-target');
                            visual.off('click').click((e) => { e.stopPropagation(); commitAttack(entity); });
                        }
                    }
                    if (mode === 'heal' && actor && currentTurn === 'player') {
                        let dist = getDistance(actor.x, actor.y, entity.x, entity.y);
                        if (dist <= 3 && entity.type !== 'enemy') {
                            shape.removeClass('anim-idle').addClass('valid-ally');
                            visual.off('click').click((e) => { e.stopPropagation(); commitHeal(entity); });
                        }
                    }
                    if (!mode) visual.click((e) => { e.stopPropagation(); if (currentTurn === 'player') openPanel(entity); });
                    cell.append(visual);
                }
                grid.append(cell);
            }
        }
        previousShipsState = {};
        ships.forEach(s => { previousShipsState[s.id] = { ...s }; });
    }

    function createEntityVisual(entity) {
        let container = $('<div></div>').addClass('entity');
        if (entity.hidden) container.addClass('is-hidden');
        let shapeClass = 'entity-shape ' + (entity.type === 'ship' ? 'type-ship' : (entity.type === 'enemy' ? 'type-enemy' : 'type-drone'));
        if (entity.subtype === 'soigneur' || (entity.name && entity.name.toLowerCase().includes('médicale'))) shapeClass = shapeClass.replace('type-ship', 'type-soigneur');
        if (entity.type === 'drone') {
            if(entity.subtype === 'kamikaze') shapeClass += ' drone-kamikaze';
            if(entity.subtype === 'scout') shapeClass += ' drone-scout';
        }
        if (entity.id == selectedShipId) shapeClass += ' active';
        let pct = (entity.hp / entity.maxHp) * 100;
        let barColor = (entity.type === 'enemy') ? 'var(--neon-red)' : 'var(--neon-green)';
        container.append(`<div class="${shapeClass}"></div><div class="hp-bar"><div class="hp-fill" style="width:${pct}%; background-color:${barColor}; box-shadow: 0 0 5px ${barColor};"></div></div>`);
        return container;
    }

    function getDistance(x1, y1, x2, y2) { return Math.abs(x1 - x2) + Math.abs(y1 - y2); }
    function playWarpOutEffect(x, y) { let e = $(`.cell[data-x='${x}'][data-y='${y}'] .entity`); if(e.length) { e.clone().removeClass('anim-idle active').addClass('fx-warp-out').css({position:'absolute',top:0,left:0,zIndex:100}).appendTo(e.parent()); e.css('opacity',0); } }
    function playDeathAnimation(x, y) { let c = $(`.cell[data-x='${x}'][data-y='${y}']`); if(c.length) c.append('<div class="fx-death"></div>').find('.fx-death').delay(1000).remove(); }
    function fireLaserEffect(s, t) { createBeam(s, t, 'laser-beam'); }
    function fireHealEffect(s, t) { createBeam(s, t, 'heal-beam'); }
    function fireExplosionEffect(x, y) { let c=$(`.cell[data-x='${x}'][data-y='${y}']`); if(c.length) $('#game-grid').append($('<div class="explosion-effect"></div>').css({top:c.position().top+25, left:c.position().left+25})).children().last().delay(600).remove(); }
    
    function createBeam(s, t, cls) {
        let c1=$(`.cell[data-x='${s.x}'][data-y='${s.y}']`), c2=$(`.cell[data-x='${t.x}'][data-y='${t.y}']`);
        if(!c1.length||!c2.length) return;
        let x1=c1.offset().left+c1.width()/2, y1=c1.offset().top+c1.height()/2, x2=c2.offset().left+c2.width()/2, y2=c2.offset().top+c2.height()/2;
        let l=Math.sqrt((x2-x1)**2+(y2-y1)**2), a=Math.atan2(y2-y1, x2-x1)*180/Math.PI;
        let b=$('<div></div>').addClass(cls).css({top:y1,left:x1,width:l,transform:`rotate(${a}deg)`}).appendTo('body');
        setTimeout(()=>b.css('opacity',0),100); setTimeout(()=>b.remove(),600);
    }

    function updateHud(msg) {
        if(msg) $('#status-text').text(msg);
        if(currentTurn === 'player') { $('#turn-label').text("TOUR ACTIF").removeClass('turn-enemy').addClass('turn-player'); $('.btn-tool').prop('disabled', false); }
        else { $('#turn-label').text("HOSTILE").removeClass('turn-player').addClass('turn-enemy'); $('#btn-end-turn').prop('disabled', true); closePanel(true); }
    }

    function openPanel(s) {
        selectedShipId = parseInt(s.id); 
        $('#panel-title').text(s.name);
        $('#info-hp').text(s.hp + "/" + s.maxHp);
        $('#info-energy').text(s.energy);
        $('#info-owner').text(s.type === 'enemy' ? "HOSTILE" : "ALLIÉ").css('color', s.type === 'enemy' ? "var(--neon-red)" : "var(--neon-green)");
        $('#info-type').text(s.subtype ? s.subtype.toUpperCase() : (s.type === 'drone' ? 'DRONE ' + (s.subtype || '') : s.type));

        $('#controls-ship, #controls-drone-kami, #controls-healer').hide();
        if (s.type !== 'enemy') {
            $('#btn-orders').show();
            if (s.subtype === 'soigneur' || (s.name && s.name.toLowerCase().includes('médicale'))) $('#controls-healer').show();
            else if (s.type === 'ship') $('#controls-ship').show();
            else if (s.type === 'drone' && s.subtype === 'kamikaze') $('#controls-drone-kami').show();
        } else $('#btn-orders').hide();

        showInfosView();
        $('#overlay, #action-panel').fadeIn(200);
    }

    window.activateMoveMode = function() { setMode('move', "Sélectionnez coordonnées de saut."); };
    window.activateDroneMode = function(st) { droneTypeToDeploy = st; setMode('drone', `Déploiement ${st} (${st=='kamikaze'?40:20} E).`); };
    window.activateAttackMode = function() { closePanel(false); setMode('attack', "Verrouillage cible requis."); };
    window.activateHealMode = function() { closePanel(false); setMode('heal', "Sélectionnez allié."); };
    
    function setMode(nm, txt) { mode=nm; $('#overlay, #action-panel').hide(); $('#btn-cancel-action').fadeIn(200); $('#status-text').text(txt).css('color','#00f3ff'); renderGame(); }
    function resetMode(msg) { mode=null; selectedShipId=null; droneTypeToDeploy=null; $('.btn-tool').removeClass('active-btn'); $('#btn-cancel-action').fadeOut(200); renderGame(); if(msg) $('#status-text').text(msg).css('color','#a0aec0'); }
    window.cancelCurrentOrder = function() { resetMode("Ordre annulé."); };
    window.closePanel = function(r=true) { $('#overlay, #action-panel').fadeOut(200); if(r) resetMode(); };
    window.showActionsView = function() { $('#view-infos').hide(); $('#view-actions').fadeIn(200); };
    window.showInfosView = function() { $('#view-actions').hide(); $('#view-infos').fadeIn(200); };
    $('#overlay').click(() => closePanel(true));
</script>
</body>
</html>