<?php
// api/lobby_action.php
require_once '../includes/db.php';
session_start();

$my_id = $_SESSION['user_id'];
$action = $_POST['action'] ?? '';

if ($action == 'play') {
    // 1. Récupération du JSON envoyé par le JS
    $fleet_json = $_POST['fleet_complex'] ?? null;
    
    if ($fleet_json) {
        $fleet_data = json_decode($fleet_json, true);

        if (is_array($fleet_data) && count($fleet_data) === 5) {
            // Nettoyage de l'ancienne flotte
            mysqli_query($link, "DELETE FROM user_fleets WHERE user_id = $my_id");
            
            // 2. Insertion de la nouvelle flotte
            // On positionne les vaisseaux temporairement à x=-1. Ils seront placés lors du match.
            foreach ($fleet_data as $ship_obj) {
                $ship_id = (int)$ship_obj['ship_id'];
                $crew_ids = json_encode($ship_obj['crew']); // On sauvegarde l'équipage !

                // Récupération stats de base (PV)
                $res_ship = mysqli_query($link, "SELECT points_vie, type FROM vaisseaux WHERE id = $ship_id");
                $data_ship = mysqli_fetch_assoc($res_ship);
                $hp = $data_ship['points_vie'];
                $type = mysqli_real_escape_string($link, $data_ship['type']);

                $sql = "INSERT INTO user_fleets (user_id, vaisseau_id, current_hp, energy, crew_json, type_ship, action_done) 
                        VALUES ($my_id, $ship_id, $hp, 100, '$crew_ids', '$type', 0)";
                mysqli_query($link, $sql);
            }

            // 3. Mise à jour statut "Prêt"
            mysqli_query($link, "UPDATE user_profiles SET ready = 1, opponent_id = NULL WHERE user_id = $my_id");

            // 4. Algorithme de Matchmaking
            // Chercher un adversaire qui est prêt (ready=1) et qui n'a pas d'adversaire (opponent_id NULL)
            $sql_match = "SELECT user_id FROM user_profiles 
                          WHERE ready = 1 AND opponent_id IS NULL AND user_id != $my_id 
                          LIMIT 1";
            $res_match = mysqli_query($link, $sql_match);

            if (mysqli_num_rows($res_match) > 0) {
                $row = mysqli_fetch_assoc($res_match);
                $opp_id = $row['user_id'];

                // a. Lier les joueurs
                mysqli_query($link, "UPDATE user_profiles SET opponent_id = $opp_id, is_my_turn = 1 WHERE user_id = $my_id"); // Je commence
                mysqli_query($link, "UPDATE user_profiles SET opponent_id = $my_id, is_my_turn = 0 WHERE user_id = $opp_id"); // Il attend

                // b. Initialiser les positions sur la grille (10x10)
                // Moi (id_user) : Colonne 0 (gauche)
                // Lui (opp_id) : Colonne 9 (droite)
                
                // Placement aléatoire sur l'axe Y pour mes vaisseaux
                $y_positions = range(0, 9);
                shuffle($y_positions);
                $my_fleets = mysqli_query($link, "SELECT id FROM user_fleets WHERE user_id = $my_id");
                $i = 0;
                while($f = mysqli_fetch_assoc($my_fleets)) {
                    $fid = $f['id'];
                    $y = $y_positions[$i++];
                    mysqli_query($link, "UPDATE user_fleets SET coord_x = 0, coord_y = $y WHERE id = $fid");
                }

                // Placement aléatoire pour l'adversaire
                shuffle($y_positions);
                $opp_fleets = mysqli_query($link, "SELECT id FROM user_fleets WHERE user_id = $opp_id");
                $j = 0;
                while($f = mysqli_fetch_assoc($opp_fleets)) {
                    $fid = $f['id'];
                    $y = $y_positions[$j++];
                    mysqli_query($link, "UPDATE user_fleets SET coord_x = 9, coord_y = $y WHERE id = $fid");
                }
            }
        }
    }
} elseif ($action == 'cancel') {
    mysqli_query($link, "UPDATE user_profiles SET ready = 0 WHERE user_id = $my_id");
}

echo json_encode(['status' => 'ok']);
mysqli_close($link);
?>