<?php

// Drone Class
class Drone {
    private $type; // 'attaque' or 'reconnaissance'
    private $energie;
    private $portee;

    public function __construct($type, $energie, $portee) {
        $this->type = $type;
        $this->energie = $energie;
        $this->portee = $portee;
    }

    // Action based on type
    public function agir($cible = null) {
        if ($this->type == 'attaque') {
            echo "Drone attaque la cible ! Dégâts infligés.<br>";
            // Logic to reduce target HP
        } elseif ($this->type == 'reconnaissance') {
            echo "Drone scanne la zone. Position de l'adversaire révélée.<br>";
            // Logic to reveal x,y
        }
    }
}

// Combat Spaceship Class (Mission 3 variant)
class VaisseauCombat {
    private $posX;
    private $posY;
    private $energie;
    private $puissanceTir;
    private $drones = []; // List of drones

    public function __construct($x, $y, $energie, $puissance) {
        $this->posX = $x;
        $this->posY = $y;
        $this->energie = $energie;
        $this->puissanceTir = $puissance;
    }

    // Move
    public function deplacer($newX, $newY) {
        $this->posX = $newX;
        $this->posY = $newY;
        echo "Vaisseau déplacé en ($newX, $newY).<br>";
    }

    // Fire
    public function tirer($cible) {
        echo "Tir effectué avec puissance {$this->puissanceTir} !<br>";
    }

    // Launch Drone
    public function lancerDrone() {
        if (!empty($this->drones)) {
            $drone = array_pop($this->drones);
            $drone->agir();
        } else {
            echo "Aucun drone disponible !<br>";
        }
    }

    public function addDrone(Drone $d) {
        $this->drones[] = $d;
    }
}
?>