<?php
// Classes/UniteSpatiale.php

abstract class UniteSpatiale implements JsonSerializable {
    protected int $id;
    protected string $name;
    protected int $x;
    protected int $y;
    protected int $hp;
    protected int $maxHp;
    protected bool $hidden;
    protected string $type; // 'ship', 'enemy', 'drone'

    public function __construct(int $id, string $name, int $x, int $y, int $maxHp, string $type) {
        $this->id = $id;
        $this->name = $name;
        $this->x = $x;
        $this->y = $y;
        $this->maxHp = $maxHp;
        $this->hp = $maxHp;
        $this->type = $type;
        $this->hidden = false;
    }

    // Gestion des déplacements (correspond à commitMove en JS)
    public function move(int $newX, int $newY): void {
        // Ici vous pouvez ajouter une vérification de distance si nécessaire
        $this->x = $newX;
        $this->y = $newY;
    }

    // Gestion des dégâts
    public function takeDamage(int $amount): void {
        $this->hp -= $amount;
        if ($this->hp < 0) $this->hp = 0;
    }

    public function isAlive(): bool {
        return $this->hp > 0;
    }

    // Permet de convertir l'objet directement en format JSON compatible avec votre JS
    public function jsonSerialize(): array {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'name' => $this->name,
            'x' => $this->x,
            'y' => $this->y,
            'hp' => $this->hp,
            'maxHp' => $this->maxHp,
            'hidden' => $this->hidden
        ];
    }

    // Getters génériques
    public function getId(): int { return $this->id; }
    public function getX(): int { return $this->x; }
    public function getY(): int { return $this->y; }
}
?>