<?php
// index.php
require_once 'includes/db.php';
session_start();

// Vérification de connexion
if (!isset($_SESSION['user_id'])) { 
    header('Location: login.php'); 
    exit(); 
}

// 1. Charger TOUS les vaisseaux dans un tableau PHP
$q_ships = mysqli_query($link, "SELECT * FROM vaisseaux");
$ships_data = [];
while($row = mysqli_fetch_assoc($q_ships)) {
    $ships_data[] = $row;
}

// 2. Charger TOUT le personnel disponible
$q_crew = mysqli_query($link, "SELECT id, nom, prenom, metier, type_personne, experience, mana FROM personnel WHERE points_vie > 0");
$crew_data = [];
while($row = mysqli_fetch_assoc($q_crew)) {
    $crew_data[] = $row;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion de Flotte Tactique</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="assets/style.css">
    <style>

        
        /* État Vide */
        
        .slot-empty:hover { border-color: #007bff; background: #eef6ff; color: #007bff; }


        

       
        /* --- ACTION BAR --- */
        #action-bar {
            position: fixed; bottom: 0; left: 0; width: 100%; background: white;
            padding: 15px; text-align: center; border-top: 1px solid #ccc;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1); z-index: 500;
        }
       
        /* --- MODALES --- */
        .modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5); }
        .modal-content { background-color: white; margin: 5vh auto; padding: 20px; border-radius: 8px; width: 70%; max-width: 800px; height: 80vh; display: flex; flex-direction: column; }
        .close-btn { font-size: 28px; cursor: pointer; color: #aaa; }
        
    </style>
</head>
<body>

    <script>
        const DB_SHIPS = <?php echo json_encode($ships_data); ?>;
        const DB_CREW  = <?php echo json_encode($crew_data); ?>;
    </script>

    <div style="max-width: 1200px; margin: 0 auto;">
        <h2>QG de la Flotte</h2>
        <p>Commandant : <b><?php echo htmlspecialchars($_SESSION['username'] ?? 'Invité'); ?></b></p>
        
        <div id="fleet-container">
            </div>
    </div>

    <div id="action-bar">
        <span id="status-text" style="margin-right: 15px; font-weight: bold; color: #555;">Flotte vide</span>
        <button id="mainActionBtn" disabled>JOUER</button>
    </div>

    <div id="shipModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Ajouter un vaisseau à la flotte</h3>
                <span class="close-btn" onclick="closeModals()">&times;</span>
            </div>
            <input type="text" id="searchShip" placeholder="Rechercher un vaisseau..." style="width: 100%; padding: 8px; margin-top: 10px; box-sizing: border-box;">
            
            <div class="table-container">
                <table id="shipTable">
                    <thead>
                        <tr>
                            <th onclick="sortTable('shipTable', 0)">Nom &#8597;</th>
                            <th onclick="sortTable('shipTable', 1)">Type &#8597;</th>
                            <th onclick="sortTable('shipTable', 2)">PV &#8597;</th>
                            <th onclick="sortTable('shipTable', 3)">Places &#8597;</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="shipTableBody"></tbody>
                </table>
            </div>
        </div>
    </div>

    <div id="crewModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="crewModalTitle">Assigner l'équipage</h3>
                <span class="close-btn" onclick="closeModals()">&times;</span>
            </div>
            
            <div style="display:flex; justify-content:space-between; align-items:center; margin-top:10px;">
                <input type="text" id="searchCrew" placeholder="Rechercher personnel..." style="padding: 8px; width: 60%;">
                <span id="crewCapacityDisplay" style="font-weight:bold;">0 / 10</span>
            </div>

            <div class="table-container">
                <table id="crewTable">
                    <thead>
                        <tr>
                            <th width="40">Select</th>
                            <th onclick="sortTable('crewTable', 1)">Nom &#8597;</th>
                            <th onclick="sortTable('crewTable', 2)">Métier &#8597;</th>
                            <th onclick="sortTable('crewTable', 3)">Niveau &#8597;</th>
                        </tr>
                    </thead>
                    <tbody id="crewTableBody"></tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        // --- ETAT DE L'APPLICATION ---
        let myFleet = []; // Tableau d'objets : { shipId, shipName, maxCrew, assignedCrew: [] }
        let currentEditIndex = -1; // Quel slot modifie-t-on ?
        let lobbyState = 0; // 0 = idle, 1 = searching

        $(document).ready(function() {
            renderFleet();
            
            // Polling Lobby
            setInterval(checkLobbyStatus, 2000);
            checkLobbyStatus();
        });

        // --- 1. RENDU DE LA FLOTTE (MAIN VIEW) ---
        function renderFleet() {
            const container = $('#fleet-container');
            container.empty();

            // On affiche toujours 5 slots (vides ou pleins)
            // Mais pour l'expérience, affichons les slots remplis + 1 bouton "Ajouter" tant que < 5
            
            // A. Afficher les vaisseaux sélectionnés
            myFleet.forEach((slot, index) => {
                let crewCount = slot.assignedCrew.length;
                let gaugeClass = (crewCount >= slot.maxCrew) ? 'full' : '';

                let html = `
                    <div class="fleet-slot slot-filled">
                        <div class="ship-header">${slot.shipName}</div>
                        <div class="ship-details">
                            <span class="stats-badge">${slot.type}</span> 
                            <span class="stats-badge">PV: ${slot.hp}</span>
                        </div>
                        <div class="crew-gauge ${gaugeClass}">
                            Équipage : ${crewCount} / ${slot.maxCrew}
                        </div>
                        <div class="slot-actions">
                            <button class="btn-small btn-manage" onclick="openCrewModal(${index})">Équipage</button>
                            <button class="btn-small btn-remove" onclick="removeShip(${index})">Retirer</button>
                        </div>
                    </div>
                `;
                container.append(html);
            });

            // B. Afficher le bouton "Ajouter" si < 5
            if (myFleet.length < 5) {
                let emptySlot = `
                    <div class="fleet-slot slot-empty" onclick="openShipModal()">
                        <div class="add-icon">+</div>
                        <div>Ajouter un Vaisseau</div>
                        <small>Slot ${myFleet.length + 1} / 5</small>
                    </div>
                `;
                container.append(emptySlot);
            }

            updateActionBar();
        }

        // --- 2. GESTION DES VAISSEAUX ---
        
        function openShipModal() {
            $('#shipModal').fadeIn(200);
            renderShipTable();
        }

        function renderShipTable() {
            const tbody = $('#shipTableBody');
            tbody.empty();
            let filter = $('#searchShip').val().toLowerCase();

            // Liste des IDs déjà dans la flotte pour ne pas les remettre
            let takenIds = myFleet.map(s => s.shipId);

            DB_SHIPS.forEach(ship => {
                // Filtre Recherche
                if (filter && !ship.nom.toLowerCase().includes(filter)) return;
                
                // Si déjà pris -> pas afficher ou griser
                if (takenIds.includes(ship.id)) return;

                let tr = `
                    <tr>
                        <td><b>${ship.nom}</b></td>
                        <td>${ship.type}</td>
                        <td>${ship.points_vie}</td>
                        <td>${ship.max_personne}</td>
                        <td>
                            <button class="btn-select" onclick="addShipToFleet(${ship.id})">Choisir</button>
                        </td>
                    </tr>
                `;
                tbody.append(tr);
            });
        }

        function addShipToFleet(id) {
            // Trouver les data du vaisseau
            let shipData = DB_SHIPS.find(s => s.id == id);
            
            // Ajouter à la flotte locale
            myFleet.push({
                shipId: shipData.id,
                shipName: shipData.nom,
                type: shipData.type,
                hp: shipData.points_vie,
                maxCrew: parseInt(shipData.max_personne),
                assignedCrew: [] // Vide au départ
            });

            closeModals();
            renderFleet();
        }

        function removeShip(index) {
            if(confirm("Retirer ce vaisseau et son équipage ?")) {
                myFleet.splice(index, 1);
                renderFleet();
            }
        }

        // --- 3. GESTION DE L'ÉQUIPAGE ---

        function openCrewModal(index) {
            currentEditIndex = index;
            let ship = myFleet[index];
            $('#crewModalTitle').text("Équipage : " + ship.shipName);
            $('#crewModal').fadeIn(200);
            renderCrewTable();
        }

        function renderCrewTable() {
            const tbody = $('#crewTableBody');
            tbody.empty();
            let filter = $('#searchCrew').val().toLowerCase();
            
            let currentShip = myFleet[currentEditIndex];
            
            // Mise à jour compteur
            let count = currentShip.assignedCrew.length;
            let max = currentShip.maxCrew;
            let disp = $('#crewCapacityDisplay');
            disp.text(`Capacité : ${count} / ${max}`);
            disp.css('color', count >= max ? 'red' : 'black');

            // Récupérer tous les membres assignés ailleurs pour les bloquer
            let allAssignedIds = [];
            myFleet.forEach((s, idx) => {
                if (idx !== currentEditIndex) {
                    allAssignedIds = allAssignedIds.concat(s.assignedCrew);
                }
            });

            DB_CREW.forEach(person => {
                // Filtre Recherche
                let fullName = (person.nom + " " + person.prenom).toLowerCase();
                let jobName = (person.metier || person.type_personne).toLowerCase();
                if (filter && !fullName.includes(filter) && !jobName.includes(filter)) return;

                // État
                let isHere = currentShip.assignedCrew.includes(person.id);
                let isTaken = allAssignedIds.includes(person.id);
                
                let stats = person.experience ? `XP: ${person.experience}` : `Mana: ${person.mana}`;
                let rowClass = isTaken ? 'row-disabled' : '';
                let disabledAttr = isTaken ? 'disabled' : '';
                
                let tr = `
                    <tr class="${rowClass}">
                        <td>
                            <input type="checkbox" class="crew-cb" value="${person.id}" 
                            ${isHere ? 'checked' : ''} ${disabledAttr}>
                        </td>
                        <td>${person.nom} ${person.prenom} ${isTaken ? '<small>(Occupé)</small>' : ''}</td>
                        <td>${person.metier || person.type_personne}</td>
                        <td>${stats}</td>
                    </tr>
                `;
                tbody.append(tr);
            });
        }

        // Clic sur Checkbox Équipage
        $(document).on('change', '.crew-cb', function() {
            let pid = $(this).val();
            let ship = myFleet[currentEditIndex];

            if ($(this).is(':checked')) {
                if (ship.assignedCrew.length >= ship.maxCrew) {
                    alert("Vaisseau complet !");
                    $(this).prop('checked', false);
                    return;
                }
                ship.assignedCrew.push(pid);
            } else {
                ship.assignedCrew = ship.assignedCrew.filter(id => id !== pid);
            }
            renderCrewTable(); // Rafraichir le compteur
        });

        // Fermeture modales
        window.closeModals = function() {
            $('.modal').fadeOut(200);
            renderFleet(); // Mettre à jour les jauges sur la page principale
        };
        
        // Listeners Recherche
        $('#searchShip').on('keyup', renderShipTable);
        $('#searchCrew').on('keyup', renderCrewTable);


        // --- 4. LOGIQUE GLOBALE ET ENVOI ---

        function updateActionBar() {
            let btn = $('#mainActionBtn');
            let txt = $('#status-text');

            if (lobbyState === 1) {
                btn.text("ANNULER RECHERCHE").css('background', '#dc3545').prop('disabled', false);
                txt.text("Recherche d'adversaire en cours...");
                // Désactiver les modifs
                $('.btn-remove, .btn-manage, .slot-empty').css('pointer-events', 'none').css('opacity', '0.5');
                return;
            }

            // Mode normal
            $('.btn-remove, .btn-manage, .slot-empty').css('pointer-events', 'auto').css('opacity', '1');
            
            if (myFleet.length === 5) {
                btn.text("JOUER").css('background', '#28a745').prop('disabled', false);
                txt.text("Flotte prête (5/5)");
            } else {
                btn.text(`JOUER (${myFleet.length}/5)`).css('background', '#28a745').prop('disabled', true);
                txt.text(`Sélectionnez 5 vaisseaux pour jouer.`);
            }
        }

        $('#mainActionBtn').click(function() {
            let action = (lobbyState === 1) ? 'cancel' : 'play';
            
            let payload = {};
            if (action === 'play') {
                // Transformer myFleet au format attendu par le serveur
                let complexData = myFleet.map(s => {
                    return { ship_id: s.shipId, crew: s.assignedCrew };
                });
                payload = { action: 'play', fleet_complex: JSON.stringify(complexData) };
            } else {
                payload = { action: 'cancel' };
            }

            $.post('api/lobby_action.php', payload, function(resp) {
                checkLobbyStatus();
            });
        });

        function checkLobbyStatus() {
            $.getJSON('api/lobby_status.php', function(data) {
                if (data.opponent_id) {
                    window.location.href = 'univers.php?opponent=' + data.opponent_id;
                    return;
                }
                lobbyState = data.am_i_ready; // 1 ou 0
                updateActionBar();
            });
        }

        // --- OUTILS : TRI DES TABLEAUX ---
        window.sortTable = function(tableId, n) {
            var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
            table = document.getElementById(tableId);
            switching = true;
            dir = "asc";
            while (switching) {
                switching = false;
                rows = table.rows;
                for (i = 1; i < (rows.length - 1); i++) {
                    shouldSwitch = false;
                    x = rows[i].getElementsByTagName("TD")[n];
                    y = rows[i + 1].getElementsByTagName("TD")[n];
                    let cmpX = isNaN(x.innerHTML) ? x.innerHTML.toLowerCase() : parseFloat(x.innerHTML);
                    let cmpY = isNaN(y.innerHTML) ? y.innerHTML.toLowerCase() : parseFloat(y.innerHTML);
                    
                    if (dir == "asc") { if (cmpX > cmpY) { shouldSwitch = true; break; } } 
                    else if (dir == "desc") { if (cmpX < cmpY) { shouldSwitch = true; break; } }
                }
                if (shouldSwitch) {
                    rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
                    switching = true;
                    switchcount++;
                } else {
                    if (switchcount == 0 && dir == "asc") { dir = "desc"; switching = true; }
                }
            }
        };
    </script>
</body>
</html>