<?php
// univers.php
if (session_status() === PHP_SESSION_NONE) { session_start(); } // <--- CORRECTION ICI
require_once 'includes/db.php'; 

// ... le reste du code
if (!isset($_SESSION['user_id'])) { header('Location: index.php'); exit(); }
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Univers - Combat Spatial 1v1</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        /* (Garder le CSS existant, rien ne change visuellement) */
        body { background-color: #0b0d17; color: white; font-family: 'Segoe UI', sans-serif; height: 100vh; display: flex; flex-direction: column; align-items: center; justify-content: center; overflow: hidden; margin: 0;}
        #hud-container { display: flex; justify-content: space-between; align-items: center; width: 500px; margin-bottom: 10px; background: #1a202c; padding: 10px 20px; border-radius: 8px; border: 2px solid #4a5568; box-sizing: border-box;}
        .hud-turn { font-size: 1.2em; font-weight: bold; }
        .turn-player { color: #4299e1; } .turn-enemy { color: #e53e3e; }
        #game-grid { display: grid; grid-template-columns: repeat(10, 1fr); width: 500px; height: 500px; border: 4px solid #2d3748; background-color: #000; position: relative; }
        .cell { border: 1px solid rgba(255, 255, 255, 0.05); display: flex; align-items: center; justify-content: center; position: relative; }
        .entity { width: 60%; height: 60%; border-radius: 4px; cursor: pointer; transition: 0.2s; z-index: 20; box-shadow: 0 0 10px currentColor; position: relative; }
        .hp-bar { position: absolute; top: -8px; left: 0; width: 100%; height: 4px; background: #333; } .hp-fill { height: 100%; background: #48bb78; }
        .type-ship { background-color: #3182ce; color: #3182ce; } .type-enemy { background-color: #e53e3e; color: #e53e3e; }
        .is-hidden { opacity: 0; pointer-events: none; } /* Vrai brouillard */
        .cell.valid-move { background-color: rgba(46, 204, 113, 0.2); cursor: pointer; border: 1px dashed #2ecc71; }
        .entity.valid-target { border: 2px solid #ff0000; animation: pulse 1s infinite; cursor: crosshair; }
        @keyframes pulse { 0% { opacity: 1; } 50% { opacity: 0.6; } 100% { opacity: 1; } }
        .toolbar { margin-top: 15px; } .btn-tool { padding: 10px 20px; font-weight: bold; cursor: pointer; }
        .btn-end { background: #ecc94b; border: none; border-radius: 4px; }
        .btn-end:disabled { opacity: 0.5; cursor: not-allowed; }
        #status-text { color: #a0aec0; height: 20px; margin-top: 10px; }
        
        /* Modal Action Simple */
        #action-panel { display:none; position: absolute; top:50%; left:50%; transform:translate(-50%, -50%); background:#1a202c; padding:20px; border:2px solid #fff; z-index:100; text-align:center; }
        .btn-act { margin: 5px; padding: 10px; display:block; width:100%; cursor:pointer; }
    </style>
</head>
<body>

    <div id="action-panel">
        <h3 id="panel-title">Ordres</h3>
        <button class="btn-act" onclick="activateMoveMode()">Déplacer</button>
        <button class="btn-act" style="background:#e53e3e; color:white;" onclick="activateAttackMode()">Tirer (10 E)</button>
        <button class="btn-act" style="background:#718096" onclick="$('#action-panel').fadeOut()">Annuler</button>
    </div>

    <div id="hud-container">
        <div class="hud-turn" id="turn-label">CHARGEMENT...</div>
        <div>VS <span id="opponent-name">Adversaire</span></div>
    </div>

    <div id="game-grid"></div>

    <div class="toolbar">
        <button class="btn-tool btn-end" id="btn-end-turn" onclick="endTurn()">FIN DE TOUR</button>
    </div>
    
    <p id="status-text">Synchronisation...</p>

    <script>
        let ships = [];
        let currentTurn = 'enemy'; // Par défaut
        let myId = <?php echo $_SESSION['user_id']; ?>;
        
        // État Interface
        let selectedShipId = null;
        let mode = null;
        let pollingInterval = null;

        $(document).ready(function() {
            syncState();
            // Polling : Vérifie l'état toutes les 2 secondes
            pollingInterval = setInterval(syncState, 2000);
        });

        function syncState() {
            // On ne sync pas si le joueur est en train de cibler (pour éviter les glitchs visuels)
            if (mode !== null) return;

            $.post('api.php', { action: 'get_state' }, function(res) {
                if(res.gameState) {
                    ships = res.gameState.entities;
                    currentTurn = res.gameState.turn;
                    renderGame();
                    updateHud(res.msg); // Message victoire/défaite éventuel
                }
            }, 'json');
        }

        function renderGame() {
            const grid = $('#game-grid');
            grid.empty();

            for (let y = 0; y < 10; y++) {
                for (let x = 0; x < 10; x++) {
                    let cell = $('<div class="cell"></div>').attr('data-x', x).attr('data-y', y);
                    let entity = ships.find(s => parseInt(s.x) === x && parseInt(s.y) === y);

                    // --- LOGIQUE CLIC VIDE ---
                    if (!entity && currentTurn === 'player') {
                         if (mode === 'move' && selectedShipId) {
                            let actor = ships.find(s => s.id == selectedShipId);
                            if(actor) {
                                let dist = Math.abs(actor.x - x) + Math.abs(actor.y - y);
                                if (dist === 1) {
                                    cell.addClass('valid-move').click(() => commitMove(x, y));
                                }
                            }
                         }
                    }

                    // --- LOGIQUE ENTITÉ ---
                    if (entity) {
                        let visual = createVisual(entity);
                        
                        // Si c'est mon tour et que je veux attaquer
                        if (mode === 'attack' && currentTurn === 'player' && entity.type === 'enemy' && !entity.hidden) {
                            let actor = ships.find(s => s.id == selectedShipId);
                            // Calcul distance simple
                            let dist = Math.abs(actor.x - entity.x) + Math.abs(actor.y - entity.y);
                            if(dist <= 4) { // Portée hardcodée
                                visual.addClass('valid-target').click((e) => {
                                    e.stopPropagation();
                                    commitAttack(entity.id);
                                });
                            }
                        }
                        
                        // Sélection pour ouvrir menu
                        if (mode === null) {
                            visual.click((e) => {
                                e.stopPropagation();
                                if(currentTurn === 'player' && entity.type === 'ship') {
                                    selectedShipId = entity.id;
                                    $('#panel-title').text(entity.name);
                                    $('#action-panel').fadeIn();
                                }
                            });
                        }
                        cell.append(visual);
                    }
                    grid.append(cell);
                }
            }
        }

        // --- ACTIONS ---
        window.activateMoveMode = function() { 
            $('#action-panel').hide(); 
            mode = 'move'; 
            renderGame(); 
            $('#status-text').text("Choisissez une case adjacente.");
        };

        function commitMove(x, y) {
            $.post('api.php', { action: 'move', id: selectedShipId, x: x, y: y }, function(res) {
                mode = null; selectedShipId = null;
                $('#status-text').text(res.msg);
                syncState(); // Force update immédiat
            }, 'json');
        }

        window.activateAttackMode = function() {
            $('#action-panel').hide();
            mode = 'attack';
            renderGame();
            $('#status-text').text("Ciblez un ennemi.");
        };

        function commitAttack(targetId) {
            $.post('api.php', { action: 'attack', attackerId: selectedShipId, targetId: targetId }, function(res) {
                mode = null; selectedShipId = null;
                $('#status-text').text(res.msg);
                syncState();
            }, 'json');
        }

        window.endTurn = function() {
            $.post('api.php', { action: 'end_turn' }, function(res) {
                if(res.success) {
                    $('#status-text').text("Tour terminé.");
                    syncState();
                } else {
                    $('#status-text').text(res.msg);
                }
            }, 'json');
        };

        // --- UTILS ---
        function updateHud(msg) {
            if(msg) alert(msg); // Victoire ou Défaite

            if(currentTurn === 'player') {
                $('#turn-label').text("À VOUS DE JOUER").css('color', '#4299e1');
                $('#btn-end-turn').prop('disabled', false);
            } else {
                $('#turn-label').text("TOUR ADVERSE").css('color', '#e53e3e');
                $('#btn-end-turn').prop('disabled', true);
                // Si action panel ouvert, le fermer
                $('#action-panel').hide();
            }
        }

        function createVisual(entity) {
            let div = $('<div>').addClass('entity');
            if (entity.type === 'ship') div.addClass('type-ship');
            else div.addClass('type-enemy');
            
            if (entity.hidden) div.addClass('is-hidden');

            let pct = (entity.hp / entity.maxHp) * 100;
            div.append(`<div class="hp-bar"><div class="hp-fill" style="width:${pct}%"></div></div>`);
            return div;
        }
    </script>
</body>
</html>