window.onload = function () {
    var canvas = document.getElementById('canvas');
    var ctx = canvas.getContext('2d');
	var clavier = new Clavier();

    var fond = new Image();
    var perso = new Image();
    fond.src = "Images/paysage.png";
    perso.src = "Images/perso.png";

    var PersoPositionX = 0;
    var PersoPositionY = 285;
    var PersoLargeur = 35;
    var PersoHauteur = 35;

    var PositionInitiale = 0;
    var Hauteur = 0;

    const Corps = [
        {Type: "LaTronche", x: 10, y: 0, Largeur: 15, Hauteur: 10},
        {Type: "BrasDroit", x: 25, y: 10, Largeur: 10, Hauteur: 20},
        {Type: "BrasGauche", x: 0, y: 10, Largeur: 10, Hauteur: 20},
        {Type: "Pieds", x: 10, y: 30, Largeur: 15, Hauteur: 10},
    ]

    const Obstacles = [
        {
            Type: "Sol",
            Elements: [
                { x: 0, y: 323, Largeur: 250, Hauteur: 13 },
                { x: 295, y: 323, Largeur: 170, Hauteur: 13 },
                { x: 510, y: 323, Largeur: 825, Hauteur: 13 },
                { x: 1390, y: 323, Largeur: 170, Hauteur: 13 },
                { x: 0, y: 453, Largeur: 150, Hauteur: 13 },
                { x: 605, y: 453, Largeur: 167, Hauteur: 13 },
                { x: 1091, y: 445, Largeur: 450, Hauteur: 13 },
                { x: 0, y: 597, Largeur: 790, Hauteur: 13 }
            ]
        },
        {
            Type: "Mur",
            Elements: [
                { x: 330, y: 240, Largeur: 5, Hauteur: 100, Class: "Normal"}
            ]
        },
        {
            Type: "Escalier",
            Elements: [
                { x: 282, y: 333, Largeur: 7, Hauteur: 6, Direction: "Gauche", Sens: "Bas", Repetition: 18 },
                { x: 465, y: 336, Largeur: 7, Hauteur: 6, Direction: "Droite", Sens: "Bas", Repetition: 18 },
                { x: 1385, y: 336, Largeur: 7, Hauteur: 6, Direction: "Gauche", Sens: "Bas", Repetition: 17 },
                { x: 150, y: 465, Largeur: 13, Hauteur: 11, Direction: "Droite", Sens: "Bas", Repetition: 11 },
                { x: 595, y: 465, Largeur: 13, Hauteur: 11, Direction: "Gauche", Sens: "Bas", Repetition: 11 }
            ]
        }
    ];

    function CheckCollision(Type,BodyPart,Class) {
        var HitBox = Corps.find(o => o.Type === BodyPart);
        var CollisionElement = Obstacles.find(o => o.Type === Type).Elements;
        for (let obs of CollisionElement) {
            var ObstacleSelected = new Obstacle(obs.x,obs.y,obs.Largeur,obs.Hauteur);
            if (ObstacleSelected.collision(PersoPositionX+HitBox.x,PersoPositionY+HitBox.y,HitBox.Largeur,HitBox.Hauteur)) {
                if (obs.Class == Class) {
                    if (Class == "Escalier") {return HitBox.Hauteur-37;}
                }
                return true;
            } 
        }
        return false;
    }

    function GetTable(Name) {return Obstacles.find(o => o.Type === Name).Elements;}

    for (let Escalier of GetTable("Escalier")) {
        let posx = Escalier.x;
        let posy = Escalier.y;
        let solData = GetTable("Sol");
        for (let pas = 0; pas < Escalier.Repetition; pas++) {
            solData.push({x: posx,y: posy,Largeur: Escalier.Largeur,Hauteur: Escalier.Hauteur, Class: "Escalier"});
            if (Escalier.Direction === "Droite") posx += Escalier.Largeur;
            if (Escalier.Direction === "Gauche") posx -= Escalier.Largeur;
            if (Escalier.Sens === "Haut") posy -= Escalier.Hauteur;
            if (Escalier.Sens === "Bas") posy += Escalier.Hauteur;
        }
    }

    function ShowHitBox() {
        ctx.globalAlpha = 0.5;
        ctx.fillStyle = "black";
        for (let Element of GetTable("Sol")) {ctx.fillRect(Element.x, Element.y, Element.Largeur, Element.Hauteur);}
        ctx.fillStyle = "red";
        for (let Element of GetTable("Mur")) {ctx.fillRect(Element.x, Element.y, Element.Largeur, Element.Hauteur);}
        ctx.fillStyle = "green";
        for (let Element of Corps) {ctx.fillRect(PersoPositionX+Element.x, PersoPositionY+Element.y, Element.Largeur, Element.Hauteur);}        
        ctx.globalAlpha = 1;
    }

    fond.onload = function () {setInterval(boucle, 20);};

    function boucle() {
        if(clavier.droite){
            console.log("ah")
            if (CheckCollision("Mur","BrasDroit","Normal") == false) {
                PersoPositionX=PersoPositionX+5;
            }
			if(PersoPositionX>1520){PersoPositionX=0;}
		}
        if(clavier.gauche){
            if (CheckCollision("Mur","BrasGauche","Normal") == false) {
                PersoPositionX=PersoPositionX-5;
            }
			if(PersoPositionX<0){PersoPositionX=1520;}
		}
        if (clavier.espace && CheckCollision("Sol","Pieds","Normal")!=false && Hauteur<=0){
			PositionInitiale = PersoPositionY;
			Hauteur = 40;
		}

        if (CheckCollision("Sol","Pieds","Normal")!=true) {
            PersoPositionY=PersoPositionY*1.03
        } 

        if (CheckCollision("Sol","Pieds","Escalier") != false&&typeof(CheckCollision("Sol","Pieds","Escalier")) == "number") {
            PersoPositionY=CheckCollision("Sol","Pieds","Escalier")
        }

        if (Hauteur>=0){
			if (Hauteur>15){
				PersoPositionY=PositionInitiale+(20-Hauteur)*(20-Hauteur)/4*1.5-150;
                if (CheckCollision("Sol","LaTronche","Normal")==true) {Hauteur=-1}
			}	
        Hauteur--;
		}

        ctx.clearRect(0,0,1560,680);
        ctx.drawImage(fond,0,0,1560,680); 
        ctx.drawImage(perso,PersoPositionX,PersoPositionY,PersoLargeur,PersoHauteur);
        ShowHitBox(); 
    }
};
